/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.api.wrapper.gui;

import java.util.Objects;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import noppes.npcs.api.NpcAPI;
import noppes.npcs.api.constants.GuiComponentType;
import noppes.npcs.api.gui.IItemSlot;
import noppes.npcs.api.item.IItemStack;
import noppes.npcs.api.wrapper.ItemStackWrapper;
import noppes.npcs.api.wrapper.gui.CustomGuiComponentWrapper;
import noppes.npcs.containers.ContainerCustomGui;

public class CustomGuiItemSlotWrapper
extends CustomGuiComponentWrapper
implements IItemSlot {
    public EntityPlayer player;
    public int slotIndex = 0;
    public IItemStack stack = ItemStackWrapper.AIR;
    public boolean showBack = true;
    public Slot slot = null;

    public CustomGuiItemSlotWrapper() {
        this(0, 0, null);
    }

    public CustomGuiItemSlotWrapper(int x, int y, IItemStack stack) {
        this.setPos(x, y);
        this.setStack(stack);
    }

    @Override
    public CustomGuiComponentWrapper fromNBT(NBTTagCompound nbt) {
        super.fromNBT(nbt);
        this.setStack(Objects.requireNonNull(NpcAPI.Instance()).getIItemStack(new ItemStack(nbt.func_74775_l("Stack"))));
        this.showBack = nbt.func_74767_n("ShowBack");
        return this;
    }

    @Override
    public Slot getMCSlot() {
        return this.slot;
    }

    @Override
    public IItemStack getStack() {
        return this.stack;
    }

    @Override
    public int getType() {
        return GuiComponentType.ITEM_SLOT.get();
    }

    @Override
    public boolean hasStack() {
        return this.stack != null && !this.stack.isEmpty();
    }

    @Override
    public boolean isShowBack() {
        return this.showBack;
    }

    @Override
    public void setShowBack(boolean bo) {
        this.showBack = bo;
    }

    @Override
    public IItemSlot setStack(IItemStack itemStack) {
        this.stack = itemStack == null ? ItemStackWrapper.AIR : itemStack;
        if (this.player != null && this.player.field_71070_bA instanceof ContainerCustomGui) {
            this.player.field_71070_bA.func_75139_a((int)this.slotIndex).field_75224_c.func_70299_a(this.slotIndex, this.stack.getMCItemStack());
            this.player.field_71070_bA.func_75139_a((int)this.slotIndex).field_75224_c.func_70296_d();
        }
        return this;
    }

    @Override
    public NBTTagCompound toNBT(NBTTagCompound nbt) {
        super.toNBT(nbt);
        nbt.func_74782_a("Stack", (NBTBase)this.stack.getMCItemStack().serializeNBT());
        nbt.func_74757_a("ShowBack", this.showBack);
        return nbt;
    }

    public void setPlayer(EntityPlayerMP player) {
        this.player = player;
    }

    public void setIndex(int index) {
        if (index < 0) {
            index *= -1;
        }
        this.slotIndex = index;
    }
}

